/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.paths;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.paths.MethodCoverageData;
import org.jetbrains.annotations.NotNull;

public final class PerFilePathCoverage
implements PerFileCoverage {
    private static final long serialVersionUID = 6075064821486644269L;
    @NotNull
    public final Map<Integer, MethodCoverageData> firstLineToMethodData = new LinkedHashMap<Integer, MethodCoverageData>();
    private transient int totalPaths;
    private transient int coveredPaths;

    public PerFilePathCoverage() {
        this.initializeCache();
    }

    private void initializeCache() {
        this.coveredPaths = -1;
        this.totalPaths = -1;
    }

    private void readObject(@NotNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.initializeCache();
        in.defaultReadObject();
    }

    public void addMethod(@NotNull MethodCoverageData methodData) {
        this.firstLineToMethodData.put(methodData.getFirstLineInBody(), methodData);
    }

    public void registerExecution(int firstLineInMethodBody, int node) {
        MethodCoverageData methodData = this.firstLineToMethodData.get(firstLineInMethodBody);
        if (methodData != null) {
            methodData.markNodeAsReached(node);
        }
    }

    @Override
    public int getTotalItems() {
        this.computeValuesIfNeeded();
        return this.totalPaths;
    }

    @Override
    public int getCoveredItems() {
        this.computeValuesIfNeeded();
        return this.coveredPaths;
    }

    @Override
    public int getCoveragePercentage() {
        this.computeValuesIfNeeded();
        return CoveragePercentage.calculate(this.coveredPaths, this.totalPaths);
    }

    private void computeValuesIfNeeded() {
        if (this.totalPaths >= 0) {
            return;
        }
        this.coveredPaths = 0;
        this.totalPaths = 0;
        for (MethodCoverageData method : this.firstLineToMethodData.values()) {
            this.totalPaths += method.getTotalPaths();
            this.coveredPaths += method.getCoveredPaths();
        }
    }

    public void reset() {
        for (MethodCoverageData methodData : this.firstLineToMethodData.values()) {
            methodData.reset();
        }
        this.initializeCache();
    }

    public void mergeInformation(@NotNull PerFilePathCoverage previousCoverage) {
        Integer firstLine;
        Map<Integer, MethodCoverageData> previousInfo = previousCoverage.firstLineToMethodData;
        for (Map.Entry<Integer, MethodCoverageData> firstLineAndInfo : this.firstLineToMethodData.entrySet()) {
            firstLine = firstLineAndInfo.getKey();
            MethodCoverageData previousPathInfo = previousInfo.get(firstLine);
            if (previousPathInfo == null) continue;
            MethodCoverageData pathInfo = firstLineAndInfo.getValue();
            pathInfo.addCountsFromPreviousTestRun(previousPathInfo);
        }
        for (Map.Entry<Integer, MethodCoverageData> firstLineAndInfo : previousInfo.entrySet()) {
            firstLine = firstLineAndInfo.getKey();
            if (this.firstLineToMethodData.containsKey(firstLine)) continue;
            this.firstLineToMethodData.put(firstLine, firstLineAndInfo.getValue());
        }
    }
}

